# CodeCanyon Submission Checklist

This checklist ensures that all requirements for a CodeCanyon submission are met.

## 1. Item Preparation
- [ ] **Source Code**: All source code is included, well-organized, and free of unnecessary files.
- [ ] **Documentation**: A comprehensive documentation file is included.
- [ ] **Assets**: All assets (images, fonts, etc.) are properly licensed and included.

## 2. Naming and Description
- [ ] **Item Name**: The item name is unique, descriptive, and follows CodeCanyon's naming conventions.
- [ ] **Description**: The item description is detailed, accurate, and properly formatted with HTML.
- [ ] **Tags**: Relevant and accurate tags have been added.

## 3. Graphics
- [ ] **Thumbnail**: A 80x80 pixel thumbnail image is created.
- [ ] **Preview Image**: A 590x300 pixel preview image is created.
- [ ] **Screenshots**: High-quality screenshots of the application are included.

## 4. Live Preview
- [ ] **Live Preview**: A functional live preview is set up and linked.
- [ ] **Responsiveness**: The live preview is fully responsive and works on all major devices.

## 5. Legal and Licensing
- [ ] **Third-Party Code**: All third-party code is properly credited and licensed.
- [ ] **License Terms**: The appropriate license (Regular or Extended) is selected.

## 6. Final Review
- [ ] **Testing**: The application has been thoroughly tested for bugs and errors.
- [ ] **Zip File**: The final zip file is correctly structured and named.
- [ ] **Instructions**: Clear instructions for the reviewer have been added to the "Message to the Reviewer" field.
