# CodeCanyon Publishing Guide

This guide provides a step-by-step overview of the publishing process on CodeCanyon.

## 1. Prepare Your Item

Before uploading, ensure your item meets CodeCanyon's quality standards.
- **Functionality:** Your item must be fully functional and free of bugs.
- **Security:** Your item must be secure and free from vulnerabilities.
- **Presentation:** Your item should be well-presented with a clear description and high-quality preview images.

## 2. Create Your Item Page

Log in to your Envato account and navigate to the "Upload an Item" page.
- **Name & Description:** Choose a descriptive name and write a detailed HTML description.
- **Files:** Upload your main zip file, which should be well-organized.
- **Images:** Upload your thumbnail (80x80) and preview images (590x300).
- **Category & Tags:** Select the appropriate category and add relevant tags.

## 3. Set Your Price

Choose a price for your item based on its complexity, features, and market value. You can select either a Regular License or an Extended License price.

## 4. The Review Process

After submission, your item will be reviewed by the Envato Quality team. This process can take several days to a few weeks.
- **Soft Rejection:** If your item has minor issues, you may receive a soft rejection with instructions on how to fix them.
- **Hard Rejection:** If your item does not meet the quality standards, it may be hard rejected.

## 5. After Approval

Once approved, your item will be published on CodeCanyon.
- **Support:** Be prepared to provide support to your customers.
- **Updates:** Regularly update your item to fix bugs, add features, and keep it current.

---

This guide is for informational purposes only. For the most up-to-date and official guidelines, please refer to the Envato Author Help Center.
