# Environment Setup Guide

The application requires environment variables to connect to Google's Generative AI services.

## 1. Create the Environment File

1.  In the root directory of the `source-code`, you will find a file named `.env.example`.
2.  Duplicate this file and rename the copy to `.env`.

## 2. Get Your Gemini API Key

1.  Go to [Google AI Studio](https://aistudio.google.com/).
2.  Sign in with your Google account.
3.  Click on the **"Get API key"** button.
4.  Click **"Create API key in new project"**.
5.  Copy the generated API key.

## 3. Add the API Key to Your `.env` File

1.  Open the `.env` file you created in step 1.
2.  You will see a line that says `GEMINI_API_KEY=`.
3.  Paste your copied API key directly after the equals sign.

**Example:**
```
GEMINI_API_KEY=AIzaSy...Your...Key...Here
```

4.  Save the `.env` file.

The application will now be ableto use its AI-powered features. When you deploy to a hosting provider, you will need to set these environment variables in their dashboard.
