# Google AI (Gemini) Setup

This project uses the Google Generative AI SDK (Gemini) for its AI features. To enable these features, you need to provide an API key.

## Steps to get your API Key

1.  **Visit Google AI Studio:**
    Open your web browser and navigate to [https://aistudio.google.com/](https://aistudio.google.com/).

2.  **Sign In:**
    Log in using your Google account.

3.  **Generate API Key:**
    -   Click on the **"Get API key"** button, usually located on the top left.
    -   In the dialog that appears, click **"Create API key in new project"**.
    -   A new API key will be generated for you.

4.  **Copy the Key:**
    Click the copy icon next to your newly generated API key.

5.  **Add Key to Project:**
    -   In the root of the project's `source-code` folder, find the `.env.example` file.
    -   Rename it to `.env`.
    -   Open the `.env` file and paste your key into the `GEMINI_API_KEY` field.
    ```
    GEMINI_API_KEY=YOUR_API_KEY_HERE
    ```

Your application's AI features are now configured.
