# Installation Guide

Follow these steps to get your WealthWise Navigator instance up and running.

## Prerequisites

-   Node.js (v18 or later)
-   npm or yarn
-   A Firebase project

## Step 1: Unzip Files

Unzip the main `codecanyon-files.zip` file you downloaded. Inside, you will find the `source-code` folder.

## Step 2: Install Dependencies

Navigate to the `source-code` directory in your terminal and run one of the following commands:

Using npm:
```bash
npm install
```

Or using yarn:
```bash
yarn install
```

## Step 3: Firebase Setup

1.  **Get Firebase Config:** Follow the `DATABASE_SETUP.md` guide to create your Firestore database and get your project configuration keys.
2.  **Run the Installer:** Once dependencies are installed, run the application:
    ```bash
    npm run dev
    ```
    The application will detect that it hasn't been configured and will automatically redirect you to the installer page at `http://localhost:3000/install`.
3.  **Follow On-Screen Instructions:** Enter your Firebase configuration details and create your admin user account as prompted by the installer.

## Step 4: Environment Variables

Follow the `ENVIRONMENT_SETUP.md` guide to set up your Google AI (Gemini) API key. This is required for the AI features of the application.

## Step 5: Run the Application

After completing the installation, you can run the application in development mode:

```bash
npm run dev
```

To build for production:

```bash
npm run build
npm run start
```

Your platform is now ready! You can log in to the admin panel using the credentials you created during installation to start configuring your site.
