
import type {NextConfig} from 'next';

const nextConfig: NextConfig = {
  /* config options here */
  // Do not ignore TypeScript or ESLint errors during builds
  typescript: {
    ignoreBuildErrors: false,
  },
  eslint: {
    ignoreDuringBuilds: false,
  },
  images: {
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 'placehold.co',
        port: '',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: 'i.postimg.cc',
        port: '',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: 'picsum.photos',
        port: '',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: 'imgpx.com',
        port: '',
        pathname: '/**',
      }
    ],
  },
};

export default nextConfig;
