import { FunctionDeclaration, Content, GenerateContentCandidate, GenerateContentResponse } from '@google/generative-ai';
import { z, JSONSchema, Genkit } from 'genkit';
import { ModelReference, ToolDefinitionSchema, MessageData, CandidateData, ModelInfo, ModelAction } from 'genkit/model';

/**
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const GeminiConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>;
type GeminiConfig = z.infer<typeof GeminiConfigSchema>;
declare const GeminiGemmaConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">>;
declare const GeminiTtsConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
declare const gemini10Pro: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini15Pro: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini15Flash: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini15Flash8b: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini20Flash: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini20FlashExp: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini20FlashLite: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini20ProExp0205: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini25FlashPreview0417: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const gemini25FlashPreviewTts: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_CIVIC_INTEGRITY"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT" | "HARM_CATEGORY_CIVIC_INTEGRITY";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "AUTO" | "ANY" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                 