"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var veo_exports = {};
__export(veo_exports, {
  GENERIC_VEO_INFO: () => GENERIC_VEO_INFO,
  VeoConfigSchema: () => VeoConfigSchema,
  defineVeoModel: () => defineVeoModel
});
module.exports = __toCommonJS(veo_exports);
var import_genkit = require("genkit");
var import_model = require("genkit/model");
var import_common = require("./common.js");
var import_predict = require("./predict.js");
const VeoConfigSchema = import_genkit.z.object({
  // NOTE: Documentation notes numberOfVideos parameter to pick the number of
  // output videos, but this setting does not seem to work
  negativePrompt: import_genkit.z.string().optional(),
  aspectRatio: import_genkit.z.enum(["9:16", "16:9"]).describe("Desired aspect ratio of the output video.").optional(),
  personGeneration: import_genkit.z.enum(["dont_allow", "allow_adult", "allow_all"]).describe(
    "Control if/how images of people will be generated by the model."
  ).optional(),
  durationSeconds: import_genkit.z.number().step(1).min(5).max(8).describe("Length of each output video in seconds, between 5 and 8.").optional(),
  enhance_prompt: import_genkit.z.boolean().describe("Enable or disable the prompt rewriter. Enabled by default.").optional()
}).passthrough();
function extractText(request) {
  return request.messages.at(-1).content.map((c) => c.text || "").join("");
}
function toParameters(request) {
  const out = {
    ...request?.config
  };
  for (const k in out) {
    if (!out[k]) delete out[k];
  }
  return out;
}
function extractImage(request) {
  const media = request.messages.at(-1)?.content.find((p) => !!p.media)?.media;
  if (media) {
    const img = media?.url.split(",")[1];
    return {
      bytesBase64Encoded: img,
      mimeType: media.contentType
    };
  }
  return void 0;
}
const GENERIC_VEO_INFO = {
  label: `Google AI - Generic Veo`,
  supports: {
    media: true,
    multiturn: false,
    tools: false,
    systemRole: false,
    output: ["media"],
    longRunning: true
  }
};
function defineVeoModel(ai, name, apiKey) {
  if (apiKey !== false) {
    apiKey = apiKey || (0, import_common.getApiKeyFromEnvVar)();
    if (!apiKey) {
      throw new import_genkit.GenkitError({
        status: "FAILED_PRECONDITION",
        message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai"
      });
    }
  }
  const modelName = `googleai/${name}`;
  const model = (0, import_model.modelRef)({
    name: modelName,
    info: {
      ...GENERIC_VEO_INFO,
      label: `Google AI - ${name}`
    },
    configSchema: VeoConfigSchema
  });
  return ai.defineBackgroundModel({
    name: modelName,
    ...model.info,
    configSchema: VeoConfigSchema,
    async start(request) {
      const instance = {
        prompt: extractText(request)
      };
      const image = extractImage(request);
      if (image) {
        instance.image = image;
      }
      const predictClient = (0, import_predict.predictModel)(model.version || name, apiKey, "predictLongRunning");
      const response = await predictClient([instance], toParameters(request));
      return toGenkitOp(response);
    },
    async check(operation) {
      const newOp = await (0, import_predict.checkOp)(operation.id, apiKey);
      return toGenkitOp(newOp);
    }
  });
}
function toGenkitOp(apiOp) {
  const res = { id: apiOp.name };
  if (apiOp.done !== void 0) {
    res.done = apiOp.done;
  }
  if (apiOp.error) {
    res.error = { message: apiOp.error.message };
  }
  if (apiOp.response && apiOp.response.generateVideoResponse && apiOp.response.generateVideoResponse.generatedSamples) {
    res.output = {
      finishReason: "stop",
      raw: apiOp.response,
      message: {
        role: "model",
        content: apiOp.response.generateVideoResponse.generatedSamples.map(
          (s) => {
            return {
              media: {
                url: s.video.uri
              }
            };
          }
        )
      }
    };
  }
  return res;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GENERIC_VEO_INFO,
  VeoConfigSchema,
  defineVeoModel
});
//# sourceMappingURL=veo.js.map